CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.columns     
                    WHERE table_name= 'est_orc_pag_cartao' 
                         and column_name='nsu_autr_ecom') THEN
                         
        RAISE NOTICE 'Coluna "nsu_autr_ecom" na tabela "est_orc_pag_cartao" ja existe!' ;
        
    ELSE
        ALTER TABLE est_orc_pag_cartao ADD COLUMN  nsu_autr_ecom varchar(30) default '0';       
        RAISE NOTICE 'Coluna "nsu_autr_ecom" criada com sucesso!';
    END IF; 
    
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();